# Copyright © 2017 Intel Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import argparse
import textwrap

HEADER = textwrap.dedent('''\
    void stringify(int foo, char * buffer);
    ''')

CODE = textwrap.dedent('''\
    #include <stdio.h>

    #ifndef WORKS
    # error "This shouldn't have been included"
    #endif

    void stringify(int foo, char * buffer) {
        sprintf(buffer, "%i", foo);
    }
    ''')


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--header')
    parser.add_argument('--code')
    args = parser.parse_args()

    with open(args.header, 'w') as f:
        f.write(HEADER)

    with open(args.code, 'w') as f:
        f.write(CODE)


if __name__ == '__main__':
    main()
